function figure = plotlygetfile(file_owner, file_id)
    [un, key, domain] = signin;

    headerFields = [ ...
            "plotly-username", string(un); ...
            "plotly-apikey", string(key); ...
            "plotly-version", plotly_version; ...
            "plotly-platform", "MATLAB"; ...
            "user-agent", "MATLAB" ...
    ];
    url = [domain, '/apigetfile/', file_owner, '/', num2str(file_id)];

    response_object = webread(url, weboptions("HeaderFields", headerFields));
    figure = response_object.payload.figure;
end
