function [axis] = extractHeatmapAxisData(obj,axis_data,axisName)
    %extract information related to each axis
    %   axis_data is the data extracted from the figure, axisName take the
    %   values 'x' 'y' or 'z'

    axiscol = "rgb(150, 150, 150)";
    lw = 0.5;
    linewidth = max(1,lw*obj.PlotlyDefaults.AxisLineIncreaseFactor);

    axis = struct( ...
        "zeroline", false, ...
        "exponentformat", obj.PlotlyDefaults.ExponentFormat, ...
        "ticklen", 0.1, ...
        "linecolor", axiscol, ...
        "tickcolor", axiscol, ...
        "gridcolor", "rgb(0, 0, 0)", ...
        "showgrid", true, ...
        "linewidth", linewidth, ...
        "tickwidth", linewidth, ...
        "gridwidth", linewidth*1.2, ...
        "ticks", "inside", ...
        "mirror", true, ...
        "showticklabels", true, ...
        "type", "category", ...
        "autorange", true, ...
        "ticktext", string(axis_data.(axisName + "DisplayLabels")), ...
        "tickvals", string(axis_data.(axisName + "DisplayData")), ...
        "autotick", false, ...
        "tickson", "boundaries", ...
        "title", struct( ...
            "text", string(axis_data.(axisName + "Label")) ...
        ), ...
        "titlefont", struct( ...
            "color", "black", ...
            "size", axis_data.FontSize*1.3, ...
            "family", matlab2plotlyfont(axis_data.FontName) ...
        ), ...
        "tickfont", struct( ...
            "color", "black", ...
            "size", axis_data.FontSize*1.15, ...
            "family", matlab2plotlyfont(axis_data.FontName) ...
        ) ...
    );

    if axis_data.Visible == "on"
        axis.showline = true;
    else
        axis.showline = false;
        axis.showticklabels = false;
        axis.ticks = "";
    end
end
