# Exercise Solutions for [Real Python's *"Python Basics: A Practical Introduction to Python 3"*](https://realpython.com/products/python-basics-book/) Book

In this code repository you find the solutions and sample implementations for the solutions and challenges posed in our [Python Basics](https://realpython.com/products/python-basics-book/) book. All solutions and sample files are ordered by chapter so you can quickly navigate to the code you're looking for.

In most cases, the solutions presented here represent just one way out of many that the exercises and challenges can be solved. If you find a better way to solve one of the exercises or challenges feel free to open an issue or pull request!

## Get the Book

[» Click here to learn more about the book and get your copy](https://realpython.com/products/python-basics-book/)

## Downloading the Files

### With `git`

If you have [`git` installed](https://realpython.com/python-git-github-intro/), the easiest way to access these files is to clone the repository to the directory of your choice:

```console
$ git clone https://github.com/realpython/python-basics-exercises.git
```

### Without `git`

Alternatively, you can download the entire repository as a `.zip` file from the repository's [homepage](https://github.com/realpython/python-basics-exercises) using the green "Clone or download" button in the top right hand corner, or by [clicking here](https://github.com/realpython/python-basics-exercises/archive/master.zip).

## Running the Solutions & Code Examples

To run the solution code and code examples, first make sure you have Python 3 installed on your machine. If you need help installing Python 3, check out our [Python 3 Installation & Setup Guide](https://realpython.com/installing-python/).

Example: To run the `3-store-a-variable.py` exercise, type `python3 3-store-a-variable.py` into your terminal. Here's how that looks, with output:

```console
$ python3 ch03-first-python-program/3-store-a-variable.py
hello
hi
```

> **Note:** Depending on your installation, you may need to type `python3.9` or `python39` to run the examples.
